require("scripts/chocshopstyle.lua");
require("scripts/transitions.lua");

MakeDialog{
    RWindow{
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        --bgColor = FColor(0,0,0),
        image = "ui/backgrounds/cs_background",
        
        VObjectWindow{
            w = kMax,
            h = kMax,
            objects = {
                endgame_diary = {
		            assets = CSStoryBackgroundAssets,
		            autoAsset = "diary",
		            autoState = "default",
	                text = {
	                    diary = { style = CSStoryLeftTextStyle, label = "story_gaberoun_10.1" },--label = "#After conquering the world, I have decided to retire to my beach house in French Polynesia, hoping never to see another chocolate for as long as I live.<br><br>This will be my final entry....<br><br>Or at least until I can think of something better to write." },
	                },
	                children = {
	                    portrait = { style = CSStoryPhotographLeft, autoState="evangeline", autoAsset="default" },
	                },
	            },
	        },
        },

        SetStyle(CSOvalLightBlueButtonStyle);
        Button{
          x = kCenter + 170,
          y = kMax - 150,
          label = "options_credits",
          command = 
            function()
                DoTransition( kFadeToBlack );
                DisplayDialog{'scripts/credits.lua', context='endgame'}; 
                CloseWindow();
            end
        }
    }
}

PostMessage( CreateNamedMessage( kFadeFromBlack ) );